#ifndef _CRC32_CPP
#define _CRC32_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CRC32.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ULONG CRCTable[256]; // CRC Lookup Table Array

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This Is The Official Polynomial Used By CRC-32 In PKZip, WinZip and Ethernet.

void InitializeCRCTable(void)
{
	ULONG Polynomial = 0x04c11db7;

	// 256 Values Representing ASCII Character Codes.
	for(int Loop1 = 0; Loop1 <= 0xFF; Loop1++)
	{
		CRCTable[Loop1] = Reflect(Loop1, 8) << 24;

		for (int Loop2 = 0; Loop2 < 8; Loop2++)
			CRCTable[Loop1] = (CRCTable[Loop1] << 1) ^ (CRCTable[Loop1] & (1 << 31) ? Polynomial : 0);

		CRCTable[Loop1] = Reflect(CRCTable[Loop1], 32);
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Reflection Is A Requirement For The Official CRC-32 Standard.
// You Can Create CRCs Without It, But They Won't Conform To The Standard.

ULONG Reflect(ULONG Reflect, char Character)
{
	ULONG Value = 0;

	// Swap Bit 0 For Bit 7 Bit 1 For Bit 6, Etc....
	for(int Loop = 1; Loop < (Character + 1); Loop++)
	{
		if(Reflect & 1) Value |= 1 << (Character - Loop);

		Reflect >>= 1;
	}

	return Value;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This function uses the CRCTable lookup table to generate a CRC for xData

DWORD FullCRC(char *xData, DWORD xLength)
{
	// Be Sure To Use Unsigned Variables,
	// Because Negative Values Introduce High Bits
	// Where Zero Bits Are Required.

    ULONG InputCRC = 0xffffffff;

	unsigned char *Buffer;

	// Save The Data In The Buffer.
	Buffer = (unsigned char*)(LPCTSTR)xData;

	// Perform The Algorithm On Each Character
	// In The String, Using The Lookup Table Values.

	while(xLength--)
        InputCRC = (InputCRC >> 8) ^ CRCTable[(InputCRC & 0xFF) ^ *Buffer++];

	return(InputCRC ^ 0xffffffff);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This function uses the CRCTable lookup table to generate a CRC for xData

DWORD PartialCRC(ULONG InputCRC, char *xData, DWORD xLength)
{
	// Be Sure To Use Unsigned Variables,
	// Because Negative Values Introduce High Bits
	// Where Zero Bits Are Required.

	unsigned char *Buffer;

	// Save The Data In The Buffer.
	Buffer = (unsigned char*)(LPCTSTR)xData;

	// Perform The Algorithm On Each Character
	// In The String, Using The Lookup Table Values.

	while(xLength--)
        InputCRC = (InputCRC >> 8) ^ CRCTable[(InputCRC & 0xFF) ^ *Buffer++];

	return(InputCRC);
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
